import torch

#对BERT输出的句子向量注入噪声 增加特征的多样性和不那么平滑特性
def add_gaussian_noise(cls_tensor, noise_level=0.1):
    noise = torch.randn_like(cls_tensor) * noise_level
    return noise + cls_tensor

def add_dropout_noise(cls_tensor, dropout_prob=0.1):
        dropout_mask = (torch.rand_like(cls_tensor) > dropout_prob).float()
        return cls_tensor * dropout_mask
    
def add_random_masking_noise(cls_tensor, mask_value=0, mask_prob=0.1):
    mask = torch.rand_like(cls_tensor) < mask_prob
    cls_tensor[mask] = mask_value
    return cls_tensor

def add_uniform_noise(self, cls_tensor, low=-0.1, high=0.2):
    noise = torch.rand_like(cls_tensor) * (high - low) + low
    return noise + cls_tensor